<?php

/**
 * This code was generated by
 * \ / _    _  _|   _  _
 * | (_)\/(_)(_|\/| |(/_  v1.0.0
 * /       /
 */

namespace Twilio\Rest\Serverless\V1\Service\TwilioFunction\FunctionVersion;

use Twilio\Exceptions\TwilioException;
use Twilio\InstanceResource;
use Twilio\Values;
use Twilio\Version;

/**
 * PLEASE NOTE that this class contains beta products that are subject to change. Use them with caution.
 *
 * @property string $sid
 * @property string $accountSid
 * @property string $serviceSid
 * @property string $functionSid
 * @property string $content
 * @property string $url
 */
class FunctionVersionContentInstance extends InstanceResource {
    /**
     * Initialize the FunctionVersionContentInstance
     *
     * @param Version $version Version that contains the resource
     * @param mixed[] $payload The response payload
     * @param string $serviceSid The SID of the Service that the Function Version
     *                           resource is associated with
     * @param string $functionSid The SID of the Function that is the parent of the
     *                            Function Version
     * @param string $sid The unique string that identifies the Function Version
     *                    resource
     */
    public function __construct(Version $version, array $payload, string $serviceSid, string $functionSid, string $sid) {
        parent::__construct($version);

        // Marshaled Properties
        $this->properties = [
            'sid' => Values::array_get($payload, 'sid'),
            'accountSid' => Values::array_get($payload, 'account_sid'),
            'serviceSid' => Values::array_get($payload, 'service_sid'),
            'functionSid' => Values::array_get($payload, 'function_sid'),
            'content' => Values::array_get($payload, 'content'),
            'url' => Values::array_get($payload, 'url'),
        ];

        $this->solution = ['serviceSid' => $serviceSid, 'functionSid' => $functionSid, 'sid' => $sid, ];
    }

    /**
     * Generate an instance context for the instance, the context is capable of
     * performing various actions.  All instance actions are proxied to the context
     *
     * @return FunctionVersionContentContext Context for this
     *                                       FunctionVersionContentInstance
     */
    protected function proxy(): FunctionVersionContentContext {
        if (!$this->context) {
            $this->context = new FunctionVersionContentContext(
                $this->version,
                $this->solution['serviceSid'],
                $this->solution['functionSid'],
                $this->solution['sid']
            );
        }

        return $this->context;
    }

    /**
     * Fetch the FunctionVersionContentInstance
     *
     * @return FunctionVersionContentInstance Fetched FunctionVersionContentInstance
     * @throws TwilioException When an HTTP error occurs.
     */
    public function fetch(): FunctionVersionContentInstance {
        return $this->proxy()->fetch();
    }

    /**
     * Magic getter to access properties
     *
     * @param string $name Property to access
     * @return mixed The requested property
     * @throws TwilioException For unknown properties
     */
    public function __get(string $name) {
        if (\array_key_exists($name, $this->properties)) {
            return $this->properties[$name];
        }

        if (\property_exists($this, '_' . $name)) {
            $method = 'get' . \ucfirst($name);
            return $this->$method();
        }

        throw new TwilioException('Unknown property: ' . $name);
    }

    /**
     * Provide a friendly representation
     *
     * @return string Machine friendly representation
     */
    public function __toString(): string {
        $context = [];
        foreach ($this->solution as $key => $value) {
            $context[] = "$key=$value";
        }
        return '[Twilio.Serverless.V1.FunctionVersionContentInstance ' . \implode(' ', $context) . ']';
    }
}